#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Adafruit_INA219.h>
Adafruit_INA219 ina219;

#define I2C_OLED_ADDRESS    0x3C
#define I2C_INA219_ADDRESS  0x40

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 32 // OLED display height, in pixels

// Declaration for an SSD1306 display connected to I2C (SDA, SCL pins)
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);

float shuntvoltage = 0;
float busvoltage = 0;
float load_Voltage = 0;
float current_mA = 0;
float power_mW = 0;

void setup() {
  Serial.begin(115200);
  ina219.begin();
  Wire.begin();

  display.begin(SSD1306_SWITCHCAPVCC, I2C_OLED_ADDRESS);
  display.clearDisplay();
  display.setTextColor(WHITE);
  display.setTextSize(1);
  display.display();
}

void loop() {
 // read data from ina219
  shuntvoltage = ina219.getShuntVoltage_mV();
  busvoltage = ina219.getBusVoltage_V();
  load_Voltage = busvoltage + (shuntvoltage / 1000);
  current_mA = ina219.getCurrent_mA();
  power_mW = ina219.getPower_mW();

//  Serial.print(busvoltage);
//  Serial.println(" V");
//  Serial.print(shuntvoltage);
//  Serial.println(" mV");
  Serial.print("Shunt Voltage:  "); Serial.print(shuntvoltage); Serial.println(" mV");
  Serial.print("Bus Voltage:  "); Serial.print(busvoltage); Serial.println(" V");
  Serial.print("Load Voltage:  "); Serial.print(load_Voltage); Serial.println(" V");
  Serial.print("Current:  "); Serial.print(current_mA); Serial.println(" mA");
  Serial.print("Power:  "); Serial.print(power_mW); Serial.println(" mW");
//  Serial.print(current_mA);
//  Serial.println(" mA");
//  Serial.print(power_mW);
//  Serial.println(" mW");
  delay(1000);

  // show data on OLED
  display.clearDisplay();

  display.setCursor(0, 0);
  display.print("V: ");
  display.print(load_Voltage);
  display.print(" V");

//  display.setCursor(60, 0);
//  display.print(shuntvoltage);
//  display.print(" mV");

  display.setCursor(0, 10);
  display.print("A: ");
  display.print(current_mA);
  display.print(" mA");

  display.setCursor(0, 20);
  display.print("W: ");
  display.print(power_mW);
  display.print(" mW");

  display.display();
}
